/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.app.print.LogoPrinter;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

public class PrintOptionsPanel
extends DataInputPanel
implements ActionListener {
    protected LogoPrinter fLogoPrinter;
    protected JCheckBox fPrintConnectorNames;
    protected JCheckBox fPrintParameter;
    protected JCheckBox fPrintParameterList;
    protected JRadioButton fPrintAllParameters;
    protected JRadioButton fPrintSelectedParameters;
    protected JRadioButton fPrintClockParameters;
    protected JCheckBox fPrintConnectorNamesList;
    protected JCheckBox fSuppressEmptyPages;
    protected JCheckBox fPrintDrawing;
    protected JCheckBox fPrintCommentPage;
    protected JCheckBox fPrintEthernetPages;
    protected JCheckBox fPrintVMMappingPages;
    protected JComboBox fPrintZoom;
    private JLabel fPrintZoomLabel;
    Hardware fHardware;

    public PrintOptionsPanel(LogoPrinter logoPrinter) {
        this.fLogoPrinter = logoPrinter;
        this.initComponents();
    }

    public void actionPerformed(ActionEvent e) {
        this.enableDisableComponents();
    }

    private void enableDisableComponents() {
        boolean printDrawing = this.fPrintDrawing.isSelected();
        this.fPrintConnectorNames.setEnabled(printDrawing);
        this.fPrintParameter.setEnabled(printDrawing);
        boolean printParameterList = this.fPrintParameterList.isSelected();
        this.fPrintAllParameters.setEnabled(printParameterList);
        this.fPrintSelectedParameters.setEnabled(printParameterList);
        this.fPrintClockParameters.setEnabled(printParameterList);
    }

    public String getTitle() {
        return Language.getString("dialog.options.printingTab.label", "Printing");
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel upperPanel = new JPanel();
        BoxLayout layout = new BoxLayout(upperPanel, 1);
        upperPanel.setLayout(layout);
        upperPanel.setAlignmentY(0.0f);
        this.add(upperPanel);
        this.fPrintCommentPage = new JCheckBox("Comment page");
        this.fPrintCommentPage.setAlignmentY(0.0f);
        upperPanel.add(this.fPrintCommentPage);
        LogoComfort l = (LogoComfort)Application.getInstance().getActiveApplicationSurface().getEditor();
        if (l != null) {
            this.fHardware = ((LogoDrawing)((LogoDrawingView)l.getView()).drawing()).getWiringDiagram().getHardware();
        }
        if (this.fHardware != null && this.fHardware.supports("supportNetwork")) {
            this.fPrintEthernetPages = new JCheckBox("Ethernet page");
            this.fPrintEthernetPages.setAlignmentY(0.0f);
            upperPanel.add(this.fPrintEthernetPages);
            this.fPrintVMMappingPages = new JCheckBox("VM Mapping page");
            this.fPrintVMMappingPages.setAlignmentY(0.0f);
            upperPanel.add(this.fPrintVMMappingPages);
        }
        upperPanel.add(Box.createVerticalStrut(5));
        this.fPrintDrawing = new JCheckBox("Drawing");
        this.fPrintDrawing.setAlignmentY(0.0f);
        upperPanel.add(this.fPrintDrawing);
        JPanel printDrawingOptionsPanel = new JPanel();
        printDrawingOptionsPanel.setAlignmentY(0.0f);
        printDrawingOptionsPanel.setLayout(new BoxLayout(printDrawingOptionsPanel, 1));
        printDrawingOptionsPanel.setBorder(new EmptyBorder(0, 20, 0, 0));
        this.fPrintConnectorNames = new JCheckBox("Connector names");
        printDrawingOptionsPanel.add(this.fPrintConnectorNames);
        this.fPrintParameter = new JCheckBox("Parameter");
        printDrawingOptionsPanel.add(this.fPrintParameter);
        upperPanel.add(printDrawingOptionsPanel);
        upperPanel.add(Box.createVerticalStrut(5));
        this.fPrintParameterList = new JCheckBox("Parameter list");
        upperPanel.add(this.fPrintParameterList);
        JPanel printParameterOptionsPanel = new JPanel();
        printParameterOptionsPanel.setLayout(new BoxLayout(printParameterOptionsPanel, 1));
        printParameterOptionsPanel.setBorder(new EmptyBorder(0, 20, 0, 0));
        this.fPrintAllParameters = new JRadioButton("All Parameters");
        printParameterOptionsPanel.add(this.fPrintAllParameters);
        this.fPrintSelectedParameters = new JRadioButton("Parameter of selected Blocks");
        printParameterOptionsPanel.add(this.fPrintSelectedParameters);
        this.fPrintClockParameters = new JRadioButton("Clock parameters");
        printParameterOptionsPanel.add(this.fPrintClockParameters);
        upperPanel.add(printParameterOptionsPanel);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.fPrintAllParameters);
        bg.add(this.fPrintSelectedParameters);
        bg.add(this.fPrintClockParameters);
        upperPanel.add(Box.createVerticalStrut(5));
        this.fPrintConnectorNamesList = new JCheckBox("Connector Names list");
        upperPanel.add(this.fPrintConnectorNamesList);
        upperPanel.add(Box.createVerticalStrut(16));
        this.fSuppressEmptyPages = new JCheckBox("Suppress empty pages");
        upperPanel.add(this.fSuppressEmptyPages);
        JPanel printZoomPanel = new JPanel();
        printZoomPanel.setLayout(new FlowLayout(0));
        this.add((Component)printZoomPanel, "South");
        this.fPrintZoomLabel = new JLabel();
        printZoomPanel.add(this.fPrintZoomLabel);
        Vector<Integer> values = new Vector<Integer>();
        values.addElement(new Integer(25));
        values.addElement(new Integer(50));
        values.addElement(new Integer(75));
        values.addElement(new Integer(100));
        values.addElement(new Integer(125));
        values.addElement(new Integer(150));
        this.fPrintZoom = new JComboBox(values);
        this.fPrintZoom.setEditable(true);
        printZoomPanel.add(this.fPrintZoom);
        printZoomPanel.add(new JLabel("%"));
        this.fPrintDrawing.addActionListener(this);
        this.fPrintParameterList.addActionListener(this);
    }

    public void loadFieldContents() {
        this.fPrintCommentPage.setSelected(this.fLogoPrinter.isPrintCommentPage());
        if (this.fHardware != null && this.fHardware.supports("supportNetwork")) {
            this.fPrintEthernetPages.setSelected(this.fLogoPrinter.isPrintEthernetPage());
            this.fPrintVMMappingPages.setSelected(this.fLogoPrinter.isPrintVMMappingPage());
        }
        this.fPrintDrawing.setSelected(this.fLogoPrinter.isPrintDrawing());
        this.fPrintConnectorNames.setSelected(this.fLogoPrinter.isPrintConnectorNamesInDrawing());
        this.fPrintParameter.setSelected(this.fLogoPrinter.isPrintParametersInDrawing());
        this.fPrintParameterList.setSelected(this.fLogoPrinter.isPrintParameterList());
        this.fPrintAllParameters.setSelected(this.fLogoPrinter.isPrintAllParameters());
        this.fPrintSelectedParameters.setSelected(this.fLogoPrinter.isPrintSelectedParameters());
        this.fPrintClockParameters.setSelected(this.fLogoPrinter.isPrintClockParameters());
        this.fPrintConnectorNamesList.setSelected(this.fLogoPrinter.isPrintConnectornameList());
        this.fSuppressEmptyPages.setSelected(this.fLogoPrinter.isSuppressEmptyPages());
        this.fPrintZoom.setSelectedItem(new Integer(this.fLogoPrinter.getPrintZoom()));
        this.enableDisableComponents();
    }

    public void setLabels() {
        this.fPrintCommentPage.setText(Language.getString("dialog.printOptions.commentPage", "Comment page"));
        if (this.fHardware != null && this.fHardware.supports("supportNetwork")) {
            this.fPrintEthernetPages.setText(Language.getString("extra.ethernet.connections", "Ethernet Connections"));
            this.fPrintVMMappingPages.setText(Language.getString("tool.vmConfigure.mapping", "Parameter VM Mapping"));
        }
        this.fPrintDrawing.setText(Language.getString("dialog.printOptions.drawing", "Drawing"));
        this.fPrintConnectorNames.setText(Language.getString("dialog.printOptions.drawing.connectorNames", "Connector names"));
        this.fPrintParameter.setText(Language.getString("dialog.printOptions.drawing.parameter", "Parameter"));
        this.fPrintParameterList.setText(Language.getString("dialog.printOptions.parameterList", "Parameter list"));
        this.fPrintAllParameters.setText(Language.getString("dialog.printOptions.parameterList.allParameters", "All parameters"));
        this.fPrintSelectedParameters.setText(Language.getString("dialog.printOptions.parameterList.selectedParameters", "Parameters of selected Blocks"));
        this.fPrintClockParameters.setText(Language.getString("dialog.printOptions.parameterList.clockParameters", "Clock parameters"));
        this.fPrintConnectorNamesList.setText(Language.getString("dialog.printOptions.connectorNamesList", "Connector names list"));
        this.fSuppressEmptyPages.setText(Language.getString("dialog.printOptions.suppressEmptyPages", "Suppress empty pages"));
        this.fPrintZoomLabel.setText(Language.getString("dialog.printOptions.printZoom", "Zoom"));
    }

    public void storeFieldContents() {
        this.fLogoPrinter.setPrintCommentPage(this.fPrintCommentPage.isSelected());
        if (this.fHardware != null && this.fHardware.supports("supportNetwork")) {
            this.fLogoPrinter.setPrintEthernetPage(this.fPrintEthernetPages.isSelected());
            this.fLogoPrinter.setPrintVMMappingPage(this.fPrintVMMappingPages.isSelected());
        }
        this.fLogoPrinter.setPrintDrawing(this.fPrintDrawing.isSelected());
        this.fLogoPrinter.setPrintConnectorNamesInDrawing(this.fPrintConnectorNames.isSelected());
        this.fLogoPrinter.setPrintParametersInDrawing(this.fPrintParameter.isSelected());
        this.fLogoPrinter.setPrintParameterList(this.fPrintParameterList.isSelected());
        this.fLogoPrinter.setPrintAllParameters(this.fPrintAllParameters.isSelected());
        this.fLogoPrinter.setPrintSelectedParameters(this.fPrintSelectedParameters.isSelected());
        this.fLogoPrinter.setPrintClockParameters(this.fPrintClockParameters.isSelected());
        this.fLogoPrinter.setPrintConnectornameList(this.fPrintConnectorNamesList.isSelected());
        this.fLogoPrinter.setSuppressEmptyPages(this.fSuppressEmptyPages.isSelected());
        int newPrintZoom = (Integer)this.fPrintZoom.getSelectedItem();
        if (this.fLogoPrinter.getPrintZoom() != newPrintZoom) {
            this.fLogoPrinter.setPrintZoom(newPrintZoom);
        }
    }

    public Icon getIcon() {
        return Global.getIcon("Print.gif");
    }
}

